/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import org.apache.log4j.Logger;

public class Cle {
    private static Logger log = Logger.getLogger(Cle.class);
    private long idCle;
    private long tailleCle = -1L;
    private long genreCle = -1L;
    private long typeCle = -1L;

    public Cle(PKCS11 pKCS11, long l, long l2, long l3) throws ExceptionObjet {
        this.idCle = l2;
        this.genreCle = l3;
        this.chargeInfo(pKCS11, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void chargeInfo(PKCS11 pKCS11, long l) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
                cK_ATTRIBUTEArray[0].type = 256L;
                cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
                cK_ATTRIBUTEArray[1].type = 289L;
                pKCS11.C_GetAttributeValue(l, this.idCle, cK_ATTRIBUTEArray);
                if (cK_ATTRIBUTEArray == null || cK_ATTRIBUTEArray.length == 0) return;
                try {
                    this.typeCle = (Long)cK_ATTRIBUTEArray[0].pValue;
                    this.tailleCle = (Long)cK_ATTRIBUTEArray[1].pValue;
                    return;
                }
                catch (ClassCastException classCastException) {
                    System.out.println("ERREUR\n:" + classCastException.getMessage());
                }
                return;
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations de la cle : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(205, "Une erreur est survenue lors de la r\u00e9cuperation des informations de la cl\u00e9");
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(205, "La librairie est nulle");
        }
    }

    public String getLibelle() {
        return "Cl\u00e9 " + Long.toString(this.idCle) + "/" + this.tailleCle + "/" + TraitementsUtil.getNomTypeCle(this.typeCle).replaceAll("_", " ").replaceAll("CKK", "");
    }

    public long getIdCle() {
        return this.idCle;
    }

    public long getTailleCle() {
        return this.tailleCle;
    }

    public boolean isClePrivee() {
        return this.genreCle == 3L;
    }

    public boolean isClePublique() {
        return this.genreCle == 2L;
    }

    public boolean isCleSecrete() {
        return this.genreCle == 4L;
    }
}

